<style>
    :root {
        /* Uzman Kariyer Brand Colors */
        --cds-background: #f4f4f4;
        --cds-layer-01: #ffffff;
        --cds-layer-02: #f4f4f4;
        --cds-text-primary: #161616;
        --cds-text-secondary: #525252;
        --cds-text-placeholder: #a8a8a8;
        --cds-text-helper: #6f6f6f;
        --cds-text-error: #da1e28;
        --cds-text-inverse: #ffffff;
        --cds-link-primary: #FF6D09;
        --cds-link-primary-hover: #E55A00;
        --cds-border-subtle: #e0e0e0;
        --cds-border-strong: #8d8d8d;
        --cds-focus: #FF6D09;
        --cds-interactive: #FF6D09;
        --cds-interactive-hover: #E55A00;
        --cds-support-error: #da1e28;
        --cds-support-success: #24a148;
        --cds-support-warning: #f1c21b;
        --cds-button-primary: #FF6D09;
        --cds-button-primary-hover: #E55A00;
        --cds-button-primary-active: #CC4D00;
        --cds-field-01: #ffffff;
        --cds-field-02: #f4f4f4;
        --cds-icon-primary: #161616;
        --cds-icon-secondary: #525252;
    }

    * {
        margin: 0;
        padding: 0;
        box-sizing: border-box;
    }

    body {
        font-family: 'IBM Plex Sans', -apple-system, BlinkMacSystemFont, sans-serif;
        background-color: var(--cds-background);
        color: var(--cds-text-primary);
        font-size: 14px;
        line-height: 1.5;
        min-height: 100vh;
        padding-bottom: 140px;
    }

    /* Header */
    .header {
        background: var(--cds-layer-01);
        border-bottom: 1px solid var(--cds-border-subtle);
        padding: 16px 20px;
        position: sticky;
        top: 0;
        z-index: 100;
    }

    .header-left { display: block; }
    .header-text { display: block; }

    .header-logo {
        max-width: 180px;
        height: auto;
        margin-bottom: 8px;
    }

    .header-title {
        font-size: 16px;
        font-weight: 600;
        color: var(--cds-text-primary);
    }

    .header-subtitle {
        font-size: 12px;
        color: var(--cds-text-secondary);
        margin-top: 2px;
    }

    .header-progress { display: none; }

    /* Progress Steps */
    .progress-container {
        background: var(--cds-layer-01);
        padding: 16px 20px;
        border-bottom: 1px solid var(--cds-border-subtle);
    }

    .progress-steps {
        display: flex;
        justify-content: space-between;
        position: relative;
    }

    .progress-steps::before {
        content: '';
        position: absolute;
        top: 12px;
        left: 24px;
        right: 24px;
        height: 2px;
        background: var(--cds-border-subtle);
    }

    .progress-step {
        display: flex;
        flex-direction: column;
        align-items: center;
        position: relative;
        z-index: 1;
    }

    .step-indicator {
        width: 24px;
        height: 24px;
        border-radius: 50%;
        background: var(--cds-layer-01);
        border: 2px solid var(--cds-border-subtle);
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 12px;
        font-weight: 600;
        color: var(--cds-text-secondary);
        transition: all 0.2s ease;
    }

    .progress-step.active .step-indicator {
        background: var(--cds-interactive);
        border-color: var(--cds-interactive);
        color: var(--cds-text-inverse);
    }

    .progress-step.completed .step-indicator {
        background: var(--cds-support-success);
        border-color: var(--cds-support-success);
        color: var(--cds-text-inverse);
    }

    .step-label {
        font-size: 10px;
        color: var(--cds-text-secondary);
        margin-top: 4px;
        text-align: center;
        max-width: 60px;
    }

    .progress-step.active .step-label {
        color: var(--cds-interactive);
        font-weight: 500;
    }

    /* Main Content */
    .main-content {
        max-width: 600px;
        margin: 0 auto;
    }

    /* Form Section */
    .form-section {
        background: var(--cds-layer-01);
        border-radius: 0;
        margin-bottom: 16px;
        display: none;
    }

    .form-section.active { display: block; }

    .section-header {
        padding: 16px;
        border-bottom: 1px solid var(--cds-border-subtle);
    }

    .section-title {
        font-size: 14px;
        font-weight: 600;
        color: var(--cds-text-primary);
    }

    .section-description {
        font-size: 12px;
        color: var(--cds-text-secondary);
        margin-top: 4px;
    }

    .section-content { padding: 16px; }

    /* Form Group */
    .form-group { margin-bottom: 24px; }
    .form-group:last-child { margin-bottom: 0; }

    .form-label {
        display: block;
        font-size: 12px;
        font-weight: 500;
        color: var(--cds-text-secondary);
        margin-bottom: 8px;
        letter-spacing: 0.32px;
    }

    .form-label .required { color: var(--cds-support-error); }

    /* Input Styles */
    .form-input {
        width: 100%;
        height: 48px;
        padding: 0 16px;
        font-size: 14px;
        font-family: inherit;
        color: var(--cds-text-primary);
        background: var(--cds-field-01);
        border: none;
        border-bottom: 1px solid var(--cds-border-strong);
        outline: none;
        transition: border-color 0.15s ease, box-shadow 0.15s ease;
    }

    .form-input:focus { border-bottom: 2px solid var(--cds-focus); }
    .form-input::placeholder { color: var(--cds-text-placeholder); }
    .form-input:disabled {
        background: var(--cds-field-02);
        color: var(--cds-text-secondary);
        cursor: not-allowed;
    }
    .form-input.error { border-bottom: 2px solid var(--cds-support-error); }

    /* Select Styles */
    .select-wrapper { position: relative; }

    .select-wrapper::after {
        content: '';
        position: absolute;
        right: 16px;
        top: 50%;
        transform: translateY(-50%);
        width: 0;
        height: 0;
        border-left: 5px solid transparent;
        border-right: 5px solid transparent;
        border-top: 5px solid var(--cds-icon-secondary);
        pointer-events: none;
    }

    .form-select {
        width: 100%;
        height: 48px;
        padding: 0 40px 0 16px;
        font-size: 14px;
        font-family: inherit;
        color: var(--cds-text-primary);
        background: var(--cds-field-01);
        border: none;
        border-bottom: 1px solid var(--cds-border-strong);
        outline: none;
        appearance: none;
        cursor: pointer;
        transition: border-color 0.15s ease;
    }

    .form-select:focus { border-bottom: 2px solid var(--cds-focus); }
    .form-select:disabled {
        background: var(--cds-field-02);
        color: var(--cds-text-placeholder);
        cursor: not-allowed;
    }

    /* Helper & Error Text */
    .helper-text {
        font-size: 12px;
        color: var(--cds-text-helper);
        margin-top: 4px;
    }

    .error-text {
        font-size: 12px;
        color: var(--cds-support-error);
        margin-top: 4px;
        display: none;
    }

    .error-text.visible { display: block; }

    /* Phone Input */
    .phone-input-wrapper {
        display: flex;
        align-items: center;
        background: var(--cds-field-01);
        border-bottom: 1px solid var(--cds-border-strong);
    }

    .phone-input-wrapper:focus-within { border-bottom: 2px solid var(--cds-focus); }

    .phone-prefix {
        padding: 0 12px;
        font-size: 14px;
        color: var(--cds-text-secondary);
        white-space: nowrap;
    }

    .phone-input {
        flex: 1;
        height: 48px;
        padding: 0 16px 0 0;
        font-size: 14px;
        font-family: inherit;
        color: var(--cds-text-primary);
        background: transparent;
        border: none;
        outline: none;
    }

    /* Autocomplete */
    .autocomplete-wrapper { position: relative; }

    .autocomplete-dropdown {
        position: absolute;
        top: 100%;
        left: 0;
        right: 0;
        background: var(--cds-layer-01);
        border: 1px solid var(--cds-border-subtle);
        box-shadow: 0 4px 8px rgba(0,0,0,0.1);
        max-height: 240px;
        overflow-y: auto;
        z-index: 1000;
        display: none;
    }

    .autocomplete-dropdown.visible { display: block; }

    .autocomplete-item {
        padding: 12px 16px;
        cursor: pointer;
        border-bottom: 1px solid var(--cds-border-subtle);
    }

    .autocomplete-item:last-child { border-bottom: none; }
    .autocomplete-item:hover,
    .autocomplete-item.highlighted { background: var(--cds-layer-02); }

    .autocomplete-item-name {
        font-size: 14px;
        color: var(--cds-text-primary);
    }

    .autocomplete-item-meta {
        font-size: 12px;
        color: var(--cds-text-secondary);
        margin-top: 2px;
    }

    /* Checkbox */
    .checkbox-wrapper {
        display: flex;
        align-items: flex-start;
        gap: 12px;
        cursor: pointer;
    }

    .checkbox-input {
        width: 20px;
        height: 20px;
        margin-top: 2px;
        accent-color: var(--cds-interactive);
        cursor: pointer;
    }

    .checkbox-label {
        font-size: 14px;
        color: var(--cds-text-primary);
        line-height: 1.5;
    }

    .checkbox-label a {
        color: var(--cds-link-primary);
        text-decoration: underline;
    }

    .checkbox-label a:hover { color: var(--cds-link-primary-hover); }

    /* Bottom Bar */
    .bottom-bar {
        position: fixed;
        bottom: 0;
        left: 0;
        right: 0;
        background: var(--cds-layer-01);
        border-top: 1px solid var(--cds-border-subtle);
        padding: 16px 20px;
        padding-bottom: calc(16px + env(safe-area-inset-bottom));
        z-index: 1000;
    }

    .bottom-bar-content {
        max-width: 600px;
        margin: 0 auto;
    }

    .nav-buttons {
        display: flex;
        gap: 12px;
        margin-bottom: 12px;
    }
    
    .nav-buttons .btn {
        min-width: 140px;
        flex: 1;
    }

    /* Buttons */
    .btn {
        height: 48px;
        padding: 0 24px;
        font-size: 14px;
        font-weight: 500;
        font-family: inherit;
        border: none;
        cursor: pointer;
        display: flex;
        align-items: center;
        justify-content: center;
        gap: 8px;
        transition: background-color 0.15s ease;
    }

    .btn-secondary {
        flex: 1;
        background: var(--cds-layer-02);
        color: var(--cds-text-primary);
        border: 1px solid var(--cds-border-strong);
    }

    .btn-secondary:hover { background: var(--cds-border-subtle); }

    .btn-primary {
        flex: 2;
        background: var(--cds-button-primary);
        color: var(--cds-text-inverse);
    }

    .btn-primary:hover { background: var(--cds-button-primary-hover); }
    .btn-primary:active { background: var(--cds-button-primary-active); }
    .btn-primary:disabled {
        background: var(--cds-border-subtle);
        color: var(--cds-text-placeholder);
        cursor: not-allowed;
    }

    .btn-full { width: 100%; }

    /* Spinner */
    .spinner {
        width: 20px;
        height: 20px;
        border: 2px solid transparent;
        border-top-color: currentColor;
        border-radius: 50%;
        animation: spin 0.8s linear infinite;
    }

    @keyframes spin { to { transform: rotate(360deg); } }

    /* Success Screen */
    .success-screen {
        display: none;
        text-align: center;
        padding: 40px 20px;
    }

    .success-screen.visible { display: block; }

    .success-icon {
        width: 64px;
        height: 64px;
        background: var(--cds-support-success);
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        margin: 0 auto 24px;
    }

    .success-icon svg {
        width: 32px;
        height: 32px;
        color: white;
    }

    .success-title {
        font-size: 20px;
        font-weight: 600;
        color: var(--cds-text-primary);
        margin-bottom: 8px;
    }

    .success-message {
        font-size: 14px;
        color: var(--cds-text-secondary);
        margin-bottom: 24px;
    }

    /* Loading Overlay */
    .loading-overlay {
        position: fixed;
        inset: 0;
        background: rgba(22, 22, 22, 0.5);
        display: none;
        align-items: center;
        justify-content: center;
        z-index: 2000;
    }

    .loading-overlay.visible { display: flex; }

    .loading-box {
        background: var(--cds-layer-01);
        padding: 24px 32px;
        display: flex;
        align-items: center;
        gap: 16px;
    }

    .loading-box .spinner {
        width: 24px;
        height: 24px;
        border-color: var(--cds-interactive);
        border-top-color: transparent;
    }

    /* Inline Loading */
    .inline-loading {
        display: none;
        align-items: center;
        gap: 8px;
        padding: 8px 0;
    }

    .inline-loading.visible { display: flex; }

    .inline-loading .spinner {
        width: 16px;
        height: 16px;
        border-width: 2px;
    }

    .inline-loading-text {
        font-size: 12px;
        color: var(--cds-text-secondary);
    }

    /* Selected Tag */
    .selected-tag {
        display: none;
        align-items: center;
        gap: 8px;
        padding: 8px 12px;
        background: #e0f2e9;
        margin-top: 8px;
        font-size: 12px;
        color: var(--cds-support-success);
    }

    .selected-tag.visible { display: inline-flex; }
    .selected-tag svg { width: 16px; height: 16px; }

    .hidden { display: none !important; }

    /* Responsive - Tablet (640px+) */
    @media (min-width: 640px) {
        .main-content { padding: 24px; }
        .form-section {
            border-radius: 4px;
            border: 1px solid var(--cds-border-subtle);
        }
        .header { padding: 20px 32px; }
        .progress-container { padding: 20px 32px; }
        .bottom-bar { padding: 20px 32px; }
    }

    /* Responsive - Tablet Landscape (768px+) */
    @media (min-width: 768px) {
        body { padding-bottom: 100px; }

        .header {
            display: flex;
            align-items: center;
            justify-content: space-between;
            padding: 12px 32px;
        }

        .header-left {
            display: flex;
            align-items: center;
            gap: 16px;
        }

        .header-logo { height: 36px; margin-bottom: 0; }

        .header-text {
            border-left: 1px solid var(--cds-border-subtle);
            padding-left: 16px;
        }

        .header-title { font-size: 16px; margin-bottom: 0; }
        .header-subtitle { display: none; }
        .progress-container { display: none; }
        .header-progress { display: flex; }

        .header-progress .progress-steps {
            display: flex;
            gap: 8px;
            align-items: center;
        }

        .header-progress .progress-step {
            flex-direction: row;
            gap: 6px;
        }

        .header-progress .step-indicator {
            width: 28px;
            height: 28px;
            font-size: 12px;
        }

        .header-progress .step-label {
            font-size: 12px;
            margin-top: 0;
            display: none;
        }

        .header-progress .progress-step.active .step-label {
            display: block;
            color: var(--cds-interactive);
            font-weight: 500;
        }

        .header-progress .progress-steps::before { display: none; }

        .header-progress .step-connector {
            width: 24px;
            height: 2px;
            background: var(--cds-border-subtle);
        }

        .header-progress .step-connector.completed {
            background: var(--cds-support-success);
        }

        .main-content { max-width: 720px; padding: 32px; }
        .section-content { padding: 24px; }

        .form-row {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 24px;
        }

        .form-row .form-group { margin-bottom: 0; }
        .bottom-bar-content { max-width: 720px; }
        .nav-buttons { max-width: 400px; margin-left: auto; }

        .grid-2 {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 24px;
        }

        .grid-2 > .form-group { margin-bottom: 0; }
    }

    /* Responsive - Desktop (1024px+) */
    @media (min-width: 1024px) {
        body { background: linear-gradient(135deg, #f8f8f8 0%, #f0f0f0 100%); }

        .header {
            padding: 16px 48px;
            box-shadow: 0 1px 3px rgba(0,0,0,0.08);
        }

        .header-logo { height: 40px; }
        .header-title { font-size: 18px; }

        .header-progress .step-indicator {
            width: 32px;
            height: 32px;
            font-size: 13px;
        }

        .header-progress .step-label { font-size: 13px; }
        .header-progress .step-connector { width: 32px; }

        .main-content { max-width: 800px; padding: 40px; }

        .form-section {
            border-radius: 8px;
            box-shadow: 0 2px 6px rgba(0,0,0,0.08);
            margin-bottom: 24px;
        }

        .section-header { padding: 20px 24px; }
        .section-title { font-size: 16px; }
        .section-content { padding: 24px 32px 32px; }

        .form-input, .form-select, .phone-input {
            height: 48px;
            font-size: 14px;
        }

        .bottom-bar {
            padding: 20px 48px;
            box-shadow: 0 -2px 8px rgba(0,0,0,0.08);
        }

        .bottom-bar-content { max-width: 800px; }
        .nav-buttons { max-width: 450px; }
        .btn { height: 48px; font-size: 14px; }
    }

    /* Responsive - Large Desktop (1280px+) */
    @media (min-width: 1280px) {
        .header { padding: 24px 64px; }
        .progress-container { padding: 32px 64px; }
        .main-content { max-width: 900px; }
        .bottom-bar { padding: 24px 64px; }
        .bottom-bar-content { max-width: 900px; }
    }

    /* Empty State */
    .empty-state {
        display: flex;
        align-items: center;
        justify-content: center;
        min-height: 60vh;
        padding: 40px 20px;
    }

    .empty-state-content {
        max-width: 500px;
        text-align: center;
    }

    .empty-state-icon {
        color: #8d8d8d;
        margin: 0 auto 24px;
        opacity: 0.5;
    }

    .empty-state-title {
        font-size: 24px;
        font-weight: 600;
        color: var(--cds-text-primary);
        margin-bottom: 12px;
    }

    .empty-state-description {
        font-size: 16px;
        color: var(--cds-text-secondary);
        line-height: 1.6;
        margin-bottom: 32px;
    }

    .empty-state-actions {
        display: flex;
        gap: 12px;
        justify-content: center;
        flex-wrap: wrap;
        margin-bottom: 32px;
    }

    .empty-state-footer {
        padding-top: 32px;
        border-top: 1px solid var(--cds-border-subtle);
    }

    .empty-state-footer p {
        font-size: 14px;
        color: var(--cds-text-secondary);
        margin-bottom: 12px;
    }

    .empty-state-contact {
        display: inline-flex;
        align-items: center;
        gap: 8px;
        font-size: 18px;
        font-weight: 600;
        color: var(--cds-interactive);
        text-decoration: none;
        transition: color 0.15s ease;
    }

    .empty-state-contact:hover {
        color: var(--cds-interactive-hover);
    }

    @media (max-width: 768px) {
        .empty-state-title {
            font-size: 20px;
        }

        .empty-state-description {
            font-size: 14px;
        }

        .empty-state-actions {
            flex-direction: column;
        }

        .empty-state-actions .btn {
            width: 100%;
        }
    }
</style>
