<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <meta name="description" content="Aday öğrenci kayıt formu">
    <title>Aday Öğrenci Kayıt Formu</title>
    
    <!-- IBM Plex Sans (Carbon Design System font) -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=IBM+Plex+Sans:wght@400;500;600;700&display=swap" rel="stylesheet">
    
    <?php include __DIR__ . '/partials/styles.php'; ?>
</head>
<body>
    <!-- Header -->
    <?php include __DIR__ . '/components/header.php'; ?>

    <!-- Mobile Progress Steps -->
    <div class="progress-container" id="mobileProgress">
        <?php $progressId = 'mobileProgressSteps'; include __DIR__ . '/components/progress-steps.php'; ?>
    </div>

    <!-- Main Content -->
    <main class="main-content">
        <?php include __DIR__ . '/components/empty-state.php'; ?>
        
        <form id="registrationForm" novalidate>
            <?php include __DIR__ . '/components/steps/step1-sinav.php'; ?>
            <?php include __DIR__ . '/components/steps/step2-ogrenci.php'; ?>
            <?php include __DIR__ . '/components/steps/step3-veli.php'; ?>
            <?php include __DIR__ . '/components/success-screen.php'; ?>
        </form>
    </main>

    <!-- Bottom Bar -->
    <?php include __DIR__ . '/components/bottom-bar.php'; ?>

    <!-- Loading Overlay -->
    <?php include __DIR__ . '/components/loading-overlay.php'; ?>

    <!-- Privacy Modal -->
    <?php include __DIR__ . '/components/modals/privacy-modal.php'; ?>

    <!-- Scripts -->
    <script src="/assets/js/api-client.js"></script>
    <script src="/assets/js/form-validation.js"></script>
    <script src="/assets/js/phone-mask.js"></script>
    <script src="/assets/js/school-autocomplete.js"></script>
    <script src="/assets/js/form-controller.js"></script>
    <script src="/assets/js/step-controller.js"></script>
    <script src="/assets/js/app.js"></script>
</body>
</html>
