<!-- Step 3: Veli Bilgileri -->
<section class="form-section" data-section="3">
    <div class="section-header">
        <h2 class="section-title">Veli Bilgileri</h2>
        <p class="section-description">İletişim için veli bilgilerini girin</p>
    </div>
    <div class="section-content">
        <div class="grid-2">
            <!-- Veli Adı -->
            <div class="form-group">
                <label class="form-label">
                    Veli Adı <span class="required">*</span>
                </label>
                <input type="text" id="parentFirstName" name="parent_first_name" 
                       class="form-input" placeholder="Adı" required autocomplete="given-name">
                <p class="error-text" id="parentFirstNameError"></p>
            </div>

            <!-- Veli Soyadı -->
            <div class="form-group">
                <label class="form-label">
                    Veli Soyadı <span class="required">*</span>
                </label>
                <input type="text" id="parentLastName" name="parent_last_name" 
                       class="form-input" placeholder="Soyadı" required autocomplete="family-name">
                <p class="error-text" id="parentLastNameError"></p>
            </div>
        </div>

        <div class="grid-2">
            <!-- Telefon 1 -->
            <div class="form-group">
                <label class="form-label">
                    Telefon Numarası <span class="required">*</span>
                </label>
                <div class="phone-input-wrapper">
                    <span class="phone-prefix">+90</span>
                    <input type="tel" id="parentPhone1" name="parent_phone1" 
                           class="phone-input" placeholder="5XX XXX XX XX" 
                           maxlength="13" required autocomplete="tel">
                </div>
                <p class="helper-text">Format: 5XX XXX XX XX</p>
                <p class="error-text" id="parentPhone1Error"></p>
            </div>

            <!-- Telefon 2 (Opsiyonel) -->
            <div class="form-group">
                <label class="form-label">
                    İkinci Telefon <span style="color: var(--cds-text-helper); font-weight: 400;">(Opsiyonel)</span>
                </label>
                <div class="phone-input-wrapper">
                    <span class="phone-prefix">+90</span>
                    <input type="tel" id="parentPhone2" name="parent_phone2" 
                           class="phone-input" placeholder="5XX XXX XX XX" 
                           maxlength="13" autocomplete="tel">
                </div>
                <p class="error-text" id="parentPhone2Error"></p>
            </div>
        </div>

        <!-- Gizlilik Politikası (tam genişlik) -->
        <div class="form-group">
            <label class="checkbox-wrapper">
                <input type="checkbox" id="policyAccepted" name="policy_accepted" 
                       class="checkbox-input" required>
                <span class="checkbox-label">
                    <a href="#" id="privacyPolicyLink">Koşullar, gizlilik ve çerez politikasını</a> 
                    okudum, kabul ediyorum. <span class="required">*</span>
                </span>
            </label>
            <p class="error-text" id="policyError"></p>
        </div>
    </div>
</section>
