<!-- Step 2: Öğrenci Bilgileri -->
<section class="form-section" data-section="2">
    <div class="section-header">
        <h2 class="section-title">Öğrenci Bilgileri</h2>
        <p class="section-description">Öğrencinin kişisel ve eğitim bilgilerini girin</p>
    </div>
    <div class="section-content">
        <div class="grid-2">
            <!-- Öğrenci Adı -->
            <div class="form-group">
                <label class="form-label">
                    Öğrenci Adı <span class="required">*</span>
                </label>
                <input type="text" id="studentFirstName" name="student_first_name" 
                       class="form-input" placeholder="Adı" required autocomplete="given-name">
                <p class="error-text" id="studentFirstNameError"></p>
            </div>

            <!-- Öğrenci Soyadı -->
            <div class="form-group">
                <label class="form-label">
                    Öğrenci Soyadı <span class="required">*</span>
                </label>
                <input type="text" id="studentLastName" name="student_last_name" 
                       class="form-input" placeholder="Soyadı" required autocomplete="family-name">
                <p class="error-text" id="studentLastNameError"></p>
            </div>
        </div>

        <div class="grid-2">
            <!-- Sınıf Düzeyi -->
            <div class="form-group">
                <label class="form-label">
                    Sınıf Düzeyi <span class="required">*</span>
                </label>
                <div class="select-wrapper">
                    <select id="gradeLevel" name="grade_level" class="form-select" required disabled>
                        <option value="">Önce şube seçiniz</option>
                    </select>
                </div>
                <div class="inline-loading" id="gradeLevelLoading">
                    <div class="spinner"></div>
                    <span class="inline-loading-text">Sınıflar yükleniyor...</span>
                </div>
                <p class="error-text" id="gradeLevelError"></p>
            </div>

            <!-- Alan Bilgisi (10-12. sınıf için) -->
            <div class="form-group hidden" id="studyFieldContainer">
                <label class="form-label">
                    Alan Bilgisi <span class="required">*</span>
                </label>
                <div class="select-wrapper">
                    <select id="studyField" name="study_field" class="form-select">
                        <option value="">Alan seçiniz</option>
                        <option value="sayisal">Sayısal</option>
                        <option value="sozel">Sözel</option>
                        <option value="esit_agirlik">Eşit Ağırlık</option>
                        <option value="dil">Dil</option>
                    </select>
                </div>
                <p class="error-text" id="studyFieldError"></p>
            </div>
        </div>

        <!-- Okul Arama (tam genişlik) -->
        <div class="form-group">
            <label class="form-label">
                Mevcut Okul <span class="required">*</span>
            </label>
            <div class="autocomplete-wrapper">
                <input type="text" id="schoolSearch" class="form-input" 
                       placeholder="Okul adı yazarak arayın (en az 3 karakter)" autocomplete="off">
                <input type="hidden" id="schoolId" name="school_id" required>
                <input type="hidden" id="schoolName" name="school_name">
                
                <div class="autocomplete-dropdown hidden" id="schoolDropdown"></div>
            </div>
            <div class="inline-loading" id="schoolLoading">
                <div class="spinner"></div>
                <span class="inline-loading-text">Okullar aranıyor...</span>
            </div>
            <div class="selected-tag" id="selectedSchool">
                <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                    <polyline points="20 6 9 17 4 12"></polyline>
                </svg>
                <span id="selectedSchoolName"></span>
            </div>
            <p class="error-text" id="schoolError"></p>
        </div>
    </div>
</section>
