<?php
/**
 * Application Bootstrap
 * 
 * Initializes the application and routes requests
 */

declare(strict_types=1);

use App\Controllers\FormController;

// Set error reporting
error_reporting(E_ALL);
ini_set('display_errors', $_ENV['APP_DEBUG'] ?? '0');

// Set default timezone
date_default_timezone_set($_ENV['APP_TIMEZONE'] ?? 'Europe/Istanbul');

// Set JSON content type for API requests
$requestUri = $_SERVER['REQUEST_URI'] ?? '';
if (strpos($requestUri, '/api/') !== false) {
    header('Content-Type: application/json; charset=utf-8');
}

// Simple router
$router = new \App\Router();

// Register routes
$router->get('/', function() {
    require __DIR__ . '/../templates/form.php';
});

// Admin Routes (order matters - specific routes first!)
$router->get('/admin/login', function() {
    require __DIR__ . '/../admin/login.php';
});

$router->post('/admin/login', function() {
    require __DIR__ . '/../admin/login.php';
});

$router->get('/admin/logout', function() {
    require __DIR__ . '/../admin/logout.php';
});

$router->get('/admin/exam-sessions', function() {
    require __DIR__ . '/../admin/exam-sessions.php';
});

$router->get('/admin/registrations', function() {
    require __DIR__ . '/../admin/registrations.php';
});

$router->get('/admin', function() {
    require __DIR__ . '/../admin/index.php';
});

// Admin API Routes
$router->get('/admin/api/exam-sessions.php', function() {
    require __DIR__ . '/../public/admin/api/exam-sessions.php';
});

$router->post('/admin/api/exam-sessions.php', function() {
    require __DIR__ . '/../public/admin/api/exam-sessions.php';
});

$router->post('/admin/api/registrations.php', function() {
    require __DIR__ . '/../public/admin/api/registrations.php';
});

// API Routes
$router->get('/api/cities', [FormController::class, 'getCities']);

// Exam System Routes
$router->get('/api/exam-types', [FormController::class, 'getExamTypes']);
$router->get('/api/exam-sessions', [FormController::class, 'getExamSessions']);
$router->get('/api/grade-levels/{examTypeId}', [FormController::class, 'getGradeLevels']);

// School Search
$router->get('/api/schools/search', [FormController::class, 'searchSchools']);

// Registration
$router->post('/api/registration', [FormController::class, 'submitRegistration']);

// Legacy Routes (backward compatibility)
$router->get('/api/branches/{cityId}', [FormController::class, 'getBranches']);

// Handle request
$router->dispatch($_SERVER['REQUEST_METHOD'], parse_url($requestUri, PHP_URL_PATH) ?? '/');
