<?php
/**
 * ValidationResult
 * 
 * Represents the result of a validation operation
 */

declare(strict_types=1);

namespace App\Services;

class ValidationResult
{
    public function __construct(
        public readonly bool $isValid,
        public readonly array $errors = []
    ) {}

    /**
     * Check if validation passed
     */
    public function isValid(): bool
    {
        return $this->isValid;
    }

    /**
     * Get all validation errors
     */
    public function getErrors(): array
    {
        return $this->errors;
    }

    /**
     * Get error for a specific field
     */
    public function getError(string $field): ?string
    {
        return $this->errors[$field] ?? null;
    }

    /**
     * Check if a specific field has an error
     */
    public function hasError(string $field): bool
    {
        return isset($this->errors[$field]);
    }

    /**
     * Convert to array for JSON response
     */
    public function toArray(): array
    {
        return [
            'valid' => $this->isValid,
            'errors' => $this->errors,
        ];
    }
}
