<?php
/**
 * StudyField Model (Alan Bilgisi)
 * 
 * Requirements: 2.2
 */

declare(strict_types=1);

namespace App\Models;

class StudyField
{
    public const SAYISAL = 'sayisal';
    public const SOZEL = 'sozel';
    public const ESIT_AGIRLIK = 'esit_agirlik';
    public const DIL = 'dil';

    /**
     * Get all available study fields
     */
    public static function getAll(): array
    {
        return [
            self::SAYISAL => 'Sayısal',
            self::SOZEL => 'Sözel',
            self::ESIT_AGIRLIK => 'Eşit Ağırlık',
            self::DIL => 'Dil',
        ];
    }

    /**
     * Check if a field value is valid
     */
    public static function isValidField(?string $field): bool
    {
        if ($field === null || $field === '') {
            return false;
        }
        return in_array($field, [
            self::SAYISAL,
            self::SOZEL,
            self::ESIT_AGIRLIK,
            self::DIL,
        ], true);
    }

    /**
     * Get display name for a field
     */
    public static function getDisplayName(string $field): ?string
    {
        $fields = self::getAll();
        return $fields[$field] ?? null;
    }
}
