<?php
/**
 * School Model (External API Response)
 * 
 * Requirements: 3.2
 */

declare(strict_types=1);

namespace App\Models;

class School
{
    public function __construct(
        public int $id = 0,
        public string $name = '',
        public int $cityId = 0,
        public string $type = '',
        public string $district = ''
    ) {}

    /**
     * Create School from API response
     */
    public static function fromArray(array $data): self
    {
        return new self(
            id: isset($data['id']) ? (int) $data['id'] : 0,
            name: $data['name'] ?? '',
            cityId: isset($data['city_id']) ? (int) $data['city_id'] : 0,
            type: $data['type'] ?? '',
            district: $data['district'] ?? ''
        );
    }

    /**
     * Convert to array
     */
    public function toArray(): array
    {
        return [
            'id' => $this->id,
            'name' => $this->name,
            'city_id' => $this->cityId,
            'type' => $this->type,
            'district' => $this->district,
        ];
    }

    /**
     * Tam okul adını döndür (ilçe dahil)
     */
    public function getFullName(): string
    {
        if (!empty($this->district)) {
            return $this->district . ' - ' . $this->name;
        }
        return $this->name;
    }
}
