<?php
/**
 * GradeLevel Model
 * 
 * Sınav türüne göre sınıf seviyeleri
 */

declare(strict_types=1);

namespace App\Models;

class GradeLevel
{
    public function __construct(
        public ?int $id = null,
        public int $examTypeId = 0,
        public int $level = 1,
        public string $displayName = '',
        public bool $isActive = true
    ) {}

    /**
     * Create GradeLevel from database row
     */
    public static function fromArray(array $data): self
    {
        return new self(
            id: isset($data['id']) ? (int) $data['id'] : null,
            examTypeId: isset($data['exam_type_id']) ? (int) $data['exam_type_id'] : 0,
            level: isset($data['grade_level']) ? (int) $data['grade_level'] : (isset($data['level']) ? (int) $data['level'] : 1),
            displayName: $data['display_name'] ?? '',
            isActive: isset($data['is_active']) ? (bool) $data['is_active'] : true
        );
    }

    /**
     * Convert to array for database operations
     */
    public function toArray(): array
    {
        return [
            'id' => $this->id,
            'exam_type_id' => $this->examTypeId,
            'grade_level' => $this->level,
            'display_name' => $this->displayName,
        ];
    }

    /**
     * Check if this grade level requires study field selection
     * 10-12. sınıflar için alan seçimi gerekli
     */
    public function requiresStudyField(): bool
    {
        return $this->level >= 10 && $this->level <= 12;
    }
}
