<?php
/**
 * ExamType Model
 * 
 * Sınav türleri: YKS Deneme, LGS Deneme, vb.
 */

declare(strict_types=1);

namespace App\Models;

use DateTime;

class ExamType
{
    public function __construct(
        public ?int $id = null,
        public string $name = '',
        public ?string $description = null,
        public bool $isActive = true,
        public ?DateTime $createdAt = null,
        public array $gradeLevels = [] // İzin verilen sınıf seviyeleri
    ) {}

    /**
     * Create ExamType from database row
     */
    public static function fromArray(array $data): self
    {
        return new self(
            id: isset($data['id']) ? (int) $data['id'] : null,
            name: $data['name'] ?? '',
            description: $data['description'] ?? null,
            isActive: isset($data['is_active']) ? (bool) $data['is_active'] : true,
            createdAt: isset($data['created_at']) ? new DateTime($data['created_at']) : null,
            gradeLevels: $data['grade_levels'] ?? []
        );
    }

    /**
     * Convert to array for API response
     */
    public function toArray(): array
    {
        return [
            'id' => $this->id,
            'name' => $this->name,
            'description' => $this->description,
            'is_active' => $this->isActive,
            'grade_levels' => $this->gradeLevels,
        ];
    }
}
