<?php
/**
 * City Model
 * 
 * Requirements: 1.2
 */

declare(strict_types=1);

namespace App\Models;

use DateTime;

class City
{
    public function __construct(
        public ?int $id = null,
        public string $name = '',
        public string $code = '',
        public bool $isActive = true,
        public ?DateTime $createdAt = null
    ) {}

    /**
     * Create City from database row
     */
    public static function fromArray(array $data): self
    {
        return new self(
            id: isset($data['id']) ? (int) $data['id'] : null,
            name: $data['name'] ?? '',
            code: $data['code'] ?? '',
            isActive: isset($data['is_active']) ? (bool) $data['is_active'] : true,
            createdAt: isset($data['created_at']) ? new DateTime($data['created_at']) : null
        );
    }

    /**
     * Convert to array for database operations
     */
    public function toArray(): array
    {
        return [
            'id' => $this->id,
            'name' => $this->name,
            'code' => $this->code,
            'is_active' => $this->isActive,
            'created_at' => $this->createdAt?->format('Y-m-d H:i:s'),
        ];
    }
}
