<?php
/**
 * Branch Model
 * 
 * Requirements: 1.2
 */

declare(strict_types=1);

namespace App\Models;

use DateTime;

class Branch
{
    public function __construct(
        public ?int $id = null,
        public int $cityId = 0,
        public string $name = '',
        public ?string $address = null,
        public bool $isActive = true,
        public ?DateTime $createdAt = null
    ) {}

    /**
     * Create Branch from database row
     */
    public static function fromArray(array $data): self
    {
        return new self(
            id: isset($data['id']) ? (int) $data['id'] : null,
            cityId: isset($data['city_id']) ? (int) $data['city_id'] : 0,
            name: $data['name'] ?? '',
            address: $data['address'] ?? null,
            isActive: isset($data['is_active']) ? (bool) $data['is_active'] : true,
            createdAt: isset($data['created_at']) ? new DateTime($data['created_at']) : null
        );
    }

    /**
     * Convert to array for database operations
     */
    public function toArray(): array
    {
        return [
            'id' => $this->id,
            'city_id' => $this->cityId,
            'name' => $this->name,
            'address' => $this->address,
            'is_active' => $this->isActive,
            'created_at' => $this->createdAt?->format('Y-m-d H:i:s'),
        ];
    }
}
