<?php
/**
 * Aday Öğrenci Kayıt Formu - Entry Point
 * 
 * Requirements: 7.1
 */

declare(strict_types=1);

// Handle static files for PHP built-in server
if (php_sapi_name() === 'cli-server') {
    $path = parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH);
    $file = __DIR__ . $path;
    
    // If it's a static file and exists, serve it
    if (is_file($file)) {
        return false;
    }
}

// Load autoloader
require_once __DIR__ . '/../vendor/autoload.php';

// Load environment variables
$dotenv = Dotenv\Dotenv::createImmutable(__DIR__ . '/..');
$dotenv->safeLoad();

// Load configuration
$config = require __DIR__ . '/../config/app.php';

// Initialize router and handle request
require_once __DIR__ . '/../src/bootstrap.php';
