/**
 * Main Application Entry Point
 * 
 * Initializes all form modules
 */

(function() {
    'use strict';

    /**
     * Initialize the application when DOM is ready
     */
    function init() {
        // Initialize phone masks
        PhoneMask.initAll();
        
        // Initialize school autocomplete
        SchoolAutocomplete.init();
        
        // Initialize form controller (loads cities and sets up events)
        FormController.init();
        
        console.log('Student Registration Form initialized');
    }

    // Initialize when DOM is ready
    if (document.readyState === 'loading') {
        document.addEventListener('DOMContentLoaded', init);
    } else {
        init();
    }
})();
