-- Migration: Create registrations table
-- Sınav kayıtları

CREATE TABLE IF NOT EXISTS registrations (
    id INT PRIMARY KEY AUTO_INCREMENT,
    city_id INT NOT NULL,
    exam_session_id INT NOT NULL,
    exam_type_id INT NOT NULL,
    grade_level INT NOT NULL,
    study_field VARCHAR(20),
    student_first_name VARCHAR(100) NOT NULL,
    student_last_name VARCHAR(100) NOT NULL,
    school_id BIGINT NOT NULL,
    school_name VARCHAR(200) NOT NULL,
    parent_first_name VARCHAR(100) NOT NULL,
    parent_last_name VARCHAR(100) NOT NULL,
    parent_phone1_encrypted VARBINARY(255) NOT NULL,
    parent_phone2_encrypted VARBINARY(255),
    policy_accepted BOOLEAN NOT NULL DEFAULT TRUE,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    INDEX idx_registrations_city_id (city_id),
    INDEX idx_registrations_exam_session_id (exam_session_id),
    INDEX idx_registrations_exam_type_id (exam_type_id),
    INDEX idx_registrations_grade_level (grade_level),
    INDEX idx_registrations_created_at (created_at),
    FOREIGN KEY (city_id) REFERENCES cities(id),
    FOREIGN KEY (exam_session_id) REFERENCES exam_sessions(id),
    FOREIGN KEY (exam_type_id) REFERENCES exam_types(id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
