-- Migration: Create exam_sessions table
-- Sınav oturumları: Tarih, saat ve şehir bazlı

CREATE TABLE IF NOT EXISTS exam_sessions (
    id INT PRIMARY KEY AUTO_INCREMENT,
    exam_type_id INT NOT NULL,
    city_id INT NOT NULL,
    exam_date DATE NOT NULL,
    exam_time TIME NOT NULL,
    location VARCHAR(255),
    capacity INT DEFAULT NULL,
    registered_count INT DEFAULT 0,
    is_active BOOLEAN DEFAULT TRUE,
    registration_deadline DATETIME,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    INDEX idx_exam_sessions_exam_type_id (exam_type_id),
    INDEX idx_exam_sessions_city_id (city_id),
    INDEX idx_exam_sessions_exam_date (exam_date),
    INDEX idx_exam_sessions_is_active (is_active),
    FOREIGN KEY (exam_type_id) REFERENCES exam_types(id) ON DELETE CASCADE,
    FOREIGN KEY (city_id) REFERENCES cities(id) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
