-- Migration: Create grade_levels table
-- Requirements: 7.1, 2.1

CREATE TABLE IF NOT EXISTS grade_levels (
    id INT PRIMARY KEY AUTO_INCREMENT,
    branch_id INT NOT NULL,
    level INT NOT NULL,
    display_name VARCHAR(50) NOT NULL,
    is_active BOOLEAN DEFAULT TRUE,
    INDEX idx_grade_levels_branch_id (branch_id),
    INDEX idx_grade_levels_level (level),
    INDEX idx_grade_levels_is_active (is_active),
    FOREIGN KEY (branch_id) REFERENCES branches(id) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
