<?php
/**
 * Application Configuration
 * 
 * Requirements: 7.1
 */

declare(strict_types=1);

return [
    'name' => $_ENV['APP_NAME'] ?? 'Aday Öğrenci Kayıt Formu',
    'env' => $_ENV['APP_ENV'] ?? 'production',
    'debug' => (bool) ($_ENV['APP_DEBUG'] ?? false),
    'url' => $_ENV['APP_URL'] ?? 'http://localhost',
    'timezone' => $_ENV['APP_TIMEZONE'] ?? 'Europe/Istanbul',
    
    // Encryption key for phone numbers (Requirements: 7.4)
    'encryption_key' => $_ENV['ENCRYPTION_KEY'] ?? '',
    
    // School API configuration
    'school_api' => [
        'base_url' => $_ENV['SCHOOL_API_URL'] ?? 'https://api.example.com/schools',
        'timeout' => 30,
    ],
];
