<?php
/**
 * Admin Login Page
 */

declare(strict_types=1);

session_start();

// If already logged in, redirect to dashboard
if (isset($_SESSION['admin_user_id'])) {
    header('Location: /admin');
    exit;
}

$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    require_once __DIR__ . '/../vendor/autoload.php';
    
    $dotenv = Dotenv\Dotenv::createImmutable(__DIR__ . '/..');
    $dotenv->safeLoad();
    
    $config = require __DIR__ . '/../config/database.php';
    
    try {
        $dsn = sprintf('%s:host=%s;port=%s;dbname=%s;charset=%s',
            $config['driver'], $config['host'], $config['port'], 
            $config['database'], $config['charset']
        );
        $pdo = new PDO($dsn, $config['username'], $config['password'], $config['options']);
        
        $username = $_POST['username'] ?? '';
        $password = $_POST['password'] ?? '';
        
        if (empty($username) || empty($password)) {
            $error = 'Kullanıcı adı ve şifre gereklidir';
        } else {
            $stmt = $pdo->prepare('SELECT * FROM users WHERE username = :username AND is_active = 1');
            $stmt->execute(['username' => $username]);
            $user = $stmt->fetch();
            
            if ($user && password_verify($password, $user['password_hash'])) {
                // Login successful
                $_SESSION['admin_user_id'] = $user['id'];
                $_SESSION['admin_username'] = $user['username'];
                $_SESSION['admin_full_name'] = $user['full_name'];
                
                // Update last login
                $pdo->prepare('UPDATE users SET last_login = NOW() WHERE id = :id')
                    ->execute(['id' => $user['id']]);
                
                header('Location: /admin');
                exit;
            } else {
                $error = 'Kullanıcı adı veya şifre hatalı';
            }
        }
    } catch (PDOException $e) {
        $error = 'Veritabanı hatası: ' . $e->getMessage();
    }
}
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Giriş Yap - Uzman Kariyer Admin</title>
    <link href="https://fonts.googleapis.com/css2?family=IBM+Plex+Sans:wght@400;500;600;700&display=swap" rel="stylesheet">
    <style>
        :root {
            --cds-background: #f4f4f4;
            --cds-layer-01: #ffffff;
            --cds-text-primary: #161616;
            --cds-text-secondary: #525252;
            --cds-text-error: #da1e28;
            --cds-border-subtle: #e0e0e0;
            --cds-interactive: #FF6D09;
            --cds-interactive-hover: #E55A00;
            --cds-button-primary: #FF6D09;
            --cds-button-primary-hover: #E55A00;
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'IBM Plex Sans', -apple-system, BlinkMacSystemFont, sans-serif;
            background-color: var(--cds-background);
            color: var(--cds-text-primary);
            display: flex;
            align-items: center;
            justify-content: center;
            min-height: 100vh;
            padding: 20px;
        }

        .login-container {
            width: 100%;
            max-width: 400px;
        }

        .login-card {
            background: var(--cds-layer-01);
            border-radius: 8px;
            padding: 40px;
            box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
        }

        .login-logo {
            text-align: center;
            margin-bottom: 32px;
        }

        .login-logo img {
            max-width: 200px;
            height: auto;
        }

        .login-title {
            font-size: 24px;
            font-weight: 600;
            text-align: center;
            margin-bottom: 8px;
        }

        .login-subtitle {
            font-size: 14px;
            color: var(--cds-text-secondary);
            text-align: center;
            margin-bottom: 32px;
        }

        .form-group {
            margin-bottom: 20px;
        }

        .form-label {
            display: block;
            font-size: 12px;
            font-weight: 500;
            margin-bottom: 8px;
            color: var(--cds-text-secondary);
        }

        .form-input {
            width: 100%;
            padding: 12px 16px;
            font-size: 14px;
            border: 1px solid var(--cds-border-subtle);
            border-radius: 4px;
            font-family: inherit;
            transition: border-color 0.15s ease;
        }

        .form-input:focus {
            outline: none;
            border-color: var(--cds-interactive);
            box-shadow: 0 0 0 2px rgba(255, 109, 9, 0.1);
        }

        .error-message {
            background: #fff1f1;
            border: 1px solid #da1e28;
            color: var(--cds-text-error);
            padding: 12px 16px;
            border-radius: 4px;
            font-size: 14px;
            margin-bottom: 20px;
        }

        .btn {
            width: 100%;
            padding: 12px 24px;
            font-size: 14px;
            font-weight: 500;
            border: none;
            border-radius: 4px;
            cursor: pointer;
            font-family: inherit;
            transition: background 0.15s ease;
        }

        .btn-primary {
            background: var(--cds-button-primary);
            color: white;
        }

        .btn-primary:hover {
            background: var(--cds-button-primary-hover);
        }

        .login-footer {
            text-align: center;
            margin-top: 24px;
            font-size: 12px;
            color: var(--cds-text-secondary);
        }
    </style>
</head>
<body>
    <div class="login-container">
        <div class="login-card">
            <div class="login-logo">
                <img src="/assets/images/logo.png" alt="Uzman Kariyer" onerror="this.style.display='none'">
            </div>
            
            <h1 class="login-title">Admin Paneli</h1>
            <p class="login-subtitle">Devam etmek için giriş yapın</p>
            
            <?php if ($error): ?>
                <div class="error-message"><?= htmlspecialchars($error) ?></div>
            <?php endif; ?>
            
            <form method="POST">
                <div class="form-group">
                    <label class="form-label">Kullanıcı Adı</label>
                    <input type="text" name="username" class="form-input" required autofocus 
                           value="<?= htmlspecialchars($_POST['username'] ?? '') ?>">
                </div>
                
                <div class="form-group">
                    <label class="form-label">Şifre</label>
                    <input type="password" name="password" class="form-input" required>
                </div>
                
                <button type="submit" class="btn btn-primary">Giriş Yap</button>
            </form>
            
            <div class="login-footer">
            </div>
        </div>
    </div>
</body>
</html>
