<style>
    :root {
        --cds-background: #f4f4f4;
        --cds-layer-01: #ffffff;
        --cds-layer-02: #f4f4f4;
        --cds-text-primary: #161616;
        --cds-text-secondary: #525252;
        --cds-text-placeholder: #a8a8a8;
        --cds-text-helper: #6f6f6f;
        --cds-text-error: #da1e28;
        --cds-text-inverse: #ffffff;
        --cds-link-primary: #FF6D09;
        --cds-link-primary-hover: #E55A00;
        --cds-border-subtle: #e0e0e0;
        --cds-border-strong: #8d8d8d;
        --cds-focus: #FF6D09;
        --cds-interactive: #FF6D09;
        --cds-interactive-hover: #E55A00;
        --cds-support-error: #da1e28;
        --cds-support-success: #24a148;
        --cds-support-warning: #f1c21b;
        --cds-button-primary: #FF6D09;
        --cds-button-primary-hover: #E55A00;
        --cds-button-primary-active: #CC4D00;
        --cds-field-01: #ffffff;
        --cds-field-02: #f4f4f4;
        --cds-icon-primary: #161616;
        --cds-icon-secondary: #525252;
    }

    * {
        margin: 0;
        padding: 0;
        box-sizing: border-box;
    }

    body {
        font-family: 'IBM Plex Sans', -apple-system, BlinkMacSystemFont, sans-serif;
        background-color: var(--cds-background);
        color: var(--cds-text-primary);
        font-size: 14px;
        line-height: 1.5;
        display: flex;
        min-height: 100vh;
    }

    /* Sidebar */
    .sidebar {
        width: 256px;
        background: var(--cds-layer-01);
        border-right: 1px solid var(--cds-border-subtle);
        display: flex;
        flex-direction: column;
        position: fixed;
        height: 100vh;
        left: 0;
        top: 0;
    }

    .sidebar-header {
        padding: 20px;
        border-bottom: 1px solid var(--cds-border-subtle);
    }

    .sidebar-logo {
        max-width: 160px;
        height: auto;
    }

    .sidebar-title {
        font-size: 16px;
        font-weight: 600;
        margin-top: 12px;
        color: var(--cds-text-primary);
    }

    .sidebar-nav {
        flex: 1;
        padding: 16px 0;
        overflow-y: auto;
    }

    .nav-item {
        display: flex;
        align-items: center;
        padding: 12px 20px;
        color: var(--cds-text-primary);
        text-decoration: none;
        transition: background 0.15s ease;
        gap: 12px;
    }

    .nav-item:hover {
        background: var(--cds-layer-02);
    }

    .nav-item.active {
        background: var(--cds-interactive);
        color: var(--cds-text-inverse);
        border-left: 3px solid var(--cds-button-primary-active);
    }

    .nav-icon {
        width: 20px;
        height: 20px;
    }

    /* Main Content */
    .main-content {
        flex: 1;
        margin-left: 256px;
        display: flex;
        flex-direction: column;
    }

    /* Header */
    .header {
        background: var(--cds-layer-01);
        border-bottom: 1px solid var(--cds-border-subtle);
        padding: 16px 32px;
        display: flex;
        justify-content: space-between;
        align-items: center;
    }

    .header-title {
        font-size: 20px;
        font-weight: 600;
    }

    .header-actions {
        display: flex;
        gap: 12px;
        align-items: center;
    }

    .user-info {
        display: flex;
        align-items: center;
        gap: 8px;
        padding: 8px 16px;
        background: var(--cds-layer-02);
        border-radius: 4px;
        font-size: 14px;
        color: var(--cds-text-primary);
    }

    .user-info svg {
        color: var(--cds-icon-secondary);
    }

    /* Content Area */
    .content {
        flex: 1;
        padding: 32px;
        overflow-y: auto;
    }

    /* Cards */
    .card {
        background: var(--cds-layer-01);
        border: 1px solid var(--cds-border-subtle);
        border-radius: 4px;
        padding: 24px;
        margin-bottom: 24px;
    }

    .card-header {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 20px;
    }

    .card-title {
        font-size: 16px;
        font-weight: 600;
    }

    /* Stats Grid */
    .stats-grid {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(240px, 1fr));
        gap: 20px;
        margin-bottom: 32px;
    }

    .stat-card {
        background: var(--cds-layer-01);
        border: 1px solid var(--cds-border-subtle);
        border-radius: 4px;
        padding: 20px;
    }

    .stat-label {
        font-size: 12px;
        color: var(--cds-text-secondary);
        text-transform: uppercase;
        letter-spacing: 0.32px;
        margin-bottom: 8px;
    }

    .stat-value {
        font-size: 32px;
        font-weight: 600;
        color: var(--cds-text-primary);
    }

    .stat-change {
        font-size: 12px;
        margin-top: 8px;
    }

    .stat-change.positive {
        color: var(--cds-support-success);
    }

    .stat-change.negative {
        color: var(--cds-support-error);
    }

    /* Table */
    .table-container {
        overflow-x: auto;
    }

    .table {
        width: 100%;
        border-collapse: collapse;
    }

    .table thead {
        background: var(--cds-layer-02);
    }

    .table th {
        text-align: left;
        padding: 12px 16px;
        font-size: 12px;
        font-weight: 600;
        color: var(--cds-text-secondary);
        text-transform: uppercase;
        letter-spacing: 0.32px;
        border-bottom: 1px solid var(--cds-border-subtle);
    }

    .table td {
        padding: 16px;
        border-bottom: 1px solid var(--cds-border-subtle);
    }

    .table tbody tr:hover {
        background: var(--cds-layer-02);
    }

    .table-compact td {
        padding: 10px 12px;
        font-size: 13px;
    }

    .table-compact th {
        padding: 10px 12px;
    }

    /* Toggle Switch */
    .toggle-switch {
        position: relative;
        display: inline-block;
        width: 48px;
        height: 24px;
    }

    .toggle-switch input {
        opacity: 0;
        width: 0;
        height: 0;
    }

    .toggle-slider {
        position: absolute;
        cursor: pointer;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background-color: #8d8d8d;
        transition: 0.2s;
        border-radius: 24px;
    }

    .toggle-slider:before {
        position: absolute;
        content: "";
        height: 18px;
        width: 18px;
        left: 3px;
        bottom: 3px;
        background-color: white;
        transition: 0.2s;
        border-radius: 50%;
    }

    .toggle-switch input:checked + .toggle-slider {
        background-color: var(--cds-support-success);
    }

    .toggle-switch input:checked + .toggle-slider:before {
        transform: translateX(24px);
    }

    .toggle-switch input:disabled + .toggle-slider {
        opacity: 0.5;
        cursor: not-allowed;
    }

    /* Pagination */
    .pagination {
        display: flex;
        align-items: center;
        justify-content: center;
        gap: 8px;
        padding: 20px;
        border-top: 1px solid var(--cds-border-subtle);
    }

    .pagination-btn {
        display: flex;
        align-items: center;
        gap: 8px;
        padding: 8px 16px;
        background: var(--cds-layer-01);
        border: 1px solid var(--cds-border-subtle);
        color: var(--cds-text-primary);
        text-decoration: none;
        font-size: 14px;
        font-weight: 500;
        border-radius: 4px;
        transition: all 0.15s ease;
    }

    .pagination-btn:hover {
        background: var(--cds-layer-02);
        border-color: var(--cds-border-strong);
    }

    .pagination-pages {
        display: flex;
        align-items: center;
        gap: 4px;
    }

    .pagination-page {
        display: flex;
        align-items: center;
        justify-content: center;
        min-width: 36px;
        height: 36px;
        padding: 0 8px;
        background: var(--cds-layer-01);
        border: 1px solid var(--cds-border-subtle);
        color: var(--cds-text-primary);
        text-decoration: none;
        font-size: 14px;
        border-radius: 4px;
        transition: all 0.15s ease;
    }

    .pagination-page:hover {
        background: var(--cds-layer-02);
        border-color: var(--cds-border-strong);
    }

    .pagination-page.active {
        background: var(--cds-interactive);
        border-color: var(--cds-interactive);
        color: var(--cds-text-inverse);
        font-weight: 600;
    }

    .pagination-ellipsis {
        padding: 0 8px;
        color: var(--cds-text-secondary);
    }

    /* Buttons */
    .btn {
        height: 40px;
        padding: 0 16px;
        font-size: 14px;
        font-weight: 500;
        font-family: inherit;
        border: none;
        cursor: pointer;
        display: inline-flex;
        align-items: center;
        justify-content: center;
        gap: 8px;
        transition: background-color 0.15s ease;
        border-radius: 0;
    }

    .btn-primary {
        background: var(--cds-button-primary);
        color: var(--cds-text-inverse);
    }

    .btn-primary:hover {
        background: var(--cds-button-primary-hover);
    }

    .btn-secondary {
        background: var(--cds-layer-02);
        color: var(--cds-text-primary);
        border: 1px solid var(--cds-border-strong);
    }

    .btn-secondary:hover {
        background: var(--cds-border-subtle);
    }

    .btn-ghost {
        background: transparent;
        color: var(--cds-text-primary);
    }

    .btn-ghost:hover {
        background: var(--cds-layer-02);
    }

    .btn-danger {
        background: var(--cds-support-error);
        color: var(--cds-text-inverse);
    }

    .btn-danger:hover {
        background: #ba1b23;
    }

    .btn-sm {
        height: 32px;
        padding: 0 12px;
        font-size: 12px;
    }

    /* Badge */
    .badge {
        display: inline-flex;
        align-items: center;
        padding: 4px 8px;
        font-size: 11px;
        font-weight: 500;
        border-radius: 2px;
        text-transform: uppercase;
        letter-spacing: 0.32px;
    }

    .badge-success {
        background: #e0f2e9;
        color: var(--cds-support-success);
    }

    .badge-warning {
        background: #fef7e0;
        color: #8e6a00;
    }

    .badge-error {
        background: #ffe0e0;
        color: var(--cds-support-error);
    }

    .badge-info {
        background: #e0f2ff;
        color: #0062ff;
    }

    /* Form Elements */
    .form-group {
        margin-bottom: 20px;
    }

    .form-label {
        display: block;
        font-size: 12px;
        font-weight: 500;
        color: var(--cds-text-secondary);
        margin-bottom: 8px;
        letter-spacing: 0.32px;
    }

    .form-input,
    .form-select,
    .form-textarea {
        width: 100%;
        padding: 11px 16px;
        font-size: 14px;
        font-family: inherit;
        color: var(--cds-text-primary);
        background: var(--cds-field-01);
        border: none;
        border-bottom: 1px solid var(--cds-border-strong);
        outline: none;
        transition: border-color 0.15s ease;
    }

    .form-input:focus,
    .form-select:focus,
    .form-textarea:focus {
        border-bottom: 2px solid var(--cds-focus);
    }

    .form-textarea {
        min-height: 100px;
        resize: vertical;
    }

    .form-select {
        appearance: none;
        background-image: url("data:image/svg+xml,%3Csvg width='16' height='16' viewBox='0 0 16 16' fill='none' xmlns='http://www.w3.org/2000/svg'%3E%3Cpath d='M8 11L3 6L13 6L8 11Z' fill='%23525252'/%3E%3C/svg%3E");
        background-repeat: no-repeat;
        background-position: right 16px center;
        padding-right: 40px;
    }

    /* Modal */
    .modal-overlay {
        position: fixed;
        inset: 0;
        background: rgba(22, 22, 22, 0.5);
        display: none;
        align-items: center;
        justify-content: center;
        z-index: 9999;
    }

    .modal-overlay.visible {
        display: flex;
    }

    .modal {
        background: var(--cds-layer-01);
        max-width: 600px;
        width: 90%;
        max-height: 90vh;
        display: flex;
        flex-direction: column;
    }

    .modal-header {
        padding: 20px 24px;
        border-bottom: 1px solid var(--cds-border-subtle);
        display: flex;
        justify-content: space-between;
        align-items: center;
    }

    .modal-title {
        font-size: 18px;
        font-weight: 600;
    }

    .modal-close {
        background: none;
        border: none;
        cursor: pointer;
        padding: 8px;
        color: var(--cds-icon-primary);
    }

    .modal-body {
        padding: 24px;
        overflow-y: auto;
    }

    .modal-footer {
        padding: 20px 24px;
        border-top: 1px solid var(--cds-border-subtle);
        display: flex;
        justify-content: flex-end;
        gap: 12px;
    }

    /* Utilities */
    .text-center { text-align: center; }
    .text-right { text-align: right; }
    .mt-1 { margin-top: 8px; }
    .mt-2 { margin-top: 16px; }
    .mt-3 { margin-top: 24px; }
    .mb-1 { margin-bottom: 8px; }
    .mb-2 { margin-bottom: 16px; }
    .mb-3 { margin-bottom: 24px; }
    .hidden { display: none !important; }
</style>
