# Implementation Plan

- [x] 1. Proje yapısı ve veritabanı kurulumu
  - [x] 1.1 Proje dizin yapısını oluştur
    - `/public` (index.php, assets)
    - `/src` (Controllers, Services, Models)
    - `/config` (database.php, app.php)
    - `/templates` (form.php)
    - `/tests` (Unit, Property)
    - _Requirements: 7.1_
  - [x] 1.2 Composer ile bağımlılıkları kur
    - PHPUnit, Eris (PBT), dotenv
    - _Requirements: 7.1_
  - [x] 1.3 Veritabanı migration dosyalarını oluştur
    - cities, branches, grade_levels, registrations tabloları
    - _Requirements: 7.1_
  - [x] 1.4 Seed data ekle (örnek şehirler ve şubeler)
    - _Requirements: 1.1, 1.2_

- [x] 2. Backend Data Models ve Validation Service
  - [x] 2.1 Model sınıflarını oluştur (City, Branch, GradeLevel, Registration, StudyField)
    - _Requirements: 1.2, 2.1, 2.2_
  - [x] 2.2 ValidationService sınıfını implement et
    - validateRegistration(), sanitizeInput(), validatePhoneNumber()
    - _Requirements: 4.2, 4.4, 7.3_
  - [x] 2.3 Property test: Phone Number Format Validation
    - **Property 8: Phone Number Format Validation**
    - **Validates: Requirements 4.2, 4.4**
  - [x] 2.4 Property test: Input Sanitization
    - **Property 12: Input Sanitization**
    - **Validates: Requirements 7.3**
  - [x] 2.5 Property test: Required Field Validation
    - **Property 6: Required Field Validation**
    - **Validates: Requirements 1.4, 3.3, 3.4, 4.3, 5.2**
  - [x] 2.6 Property test: Conditional Study Field Validation
    - **Property 7: Conditional Study Field Validation**
    - **Validates: Requirements 2.4**
  - [x] 2.7 Property test: Optional Phone2 Validation
    - **Property 9: Optional Phone2 Validation**
    - **Validates: Requirements 4.5**

- [x] 3. Database Service ve Encryption
  - [x] 3.1 DatabaseService sınıfını implement et
    - PDO connection, getCities(), getBranchesByCity(), getGradeLevelsByBranch()
    - _Requirements: 1.2, 2.1_
  - [x] 3.2 EncryptionService sınıfını implement et
    - encrypt(), decrypt() metodları (AES-256)
    - _Requirements: 7.4_
  - [x] 3.3 saveRegistration() metodunu implement et
    - Telefon şifreleme dahil
    - _Requirements: 7.1, 7.4_
  - [x] 3.4 Property test: Phone Encryption Round-Trip
    - **Property 11: Phone Encryption Round-Trip**
    - **Validates: Requirements 7.4**
  - [x] 3.5 Property test: Registration Data Round-Trip
    - **Property 10: Registration Data Round-Trip**
    - **Validates: Requirements 7.1**

- [x] 4. Checkpoint - Tüm testlerin geçtiğinden emin ol
  - Ensure all tests pass, ask the user if questions arise.

- [x] 5. API Controller ve Endpoints
  - [x] 5.1 Router sınıfını oluştur (basit PHP router)
    - _Requirements: 1.2, 2.1, 3.2_
  - [x] 5.2 FormController sınıfını implement et
    - getCities(), getBranches(), getGradeLevels(), searchSchools(), submitRegistration()
    - _Requirements: 1.2, 2.1, 3.2, 7.1_
  - [x] 5.3 School API client'ı implement et (mock veya gerçek API)
    - _Requirements: 3.2_
  - [x] 5.4 Property test: Branch Filtering by City
    - **Property 1: Branch Filtering by City**
    - **Validates: Requirements 1.2**
  - [x] 5.5 Property test: Grade Level Filtering by Branch
    - **Property 3: Grade Level Filtering by Branch**
    - **Validates: Requirements 2.1**
  - [x] 5.6 Property test: School Search Returns City-Filtered Results
    - **Property 5: School Search Returns City-Filtered Results**
    - **Validates: Requirements 3.2**

- [x] 6. Frontend HTML/CSS Yapısı
  - [x] 6.1 TailwindCSS kurulumu ve konfigürasyonu
    - _Requirements: 6.1, 6.2_
  - [x] 6.2 Form HTML template'ini oluştur (form.php)
    - Mobil öncelikli, tek sütun layout
    - Tüm form alanları (şehir, şube, sınıf, alan, öğrenci, veli, telefon, onay)
    - _Requirements: 1.1, 2.1, 3.1, 4.1, 5.1, 6.1, 6.2_
  - [x] 6.3 Loading spinner ve hata mesajı componentlerini ekle
    - _Requirements: 6.4, 7.2_

- [x] 7. Frontend JavaScript Controller
  - [x] 7.1 APIClient modülünü oluştur
    - getCities(), getBranches(), getGradeLevels(), searchSchools(), submitRegistration()
    - _Requirements: 1.2, 2.1, 3.2_
  - [x] 7.2 FormController modülünü oluştur
    - State yönetimi, event handlers, form akışı
    - _Requirements: 1.2, 1.3, 2.2, 2.3_
  - [x] 7.3 Client-side validation modülünü oluştur
    - _Requirements: 4.2, 4.4_
  - [x] 7.4 Telefon input mask'ını implement et
    - _Requirements: 4.2_
  - [x] 7.5 Okul arama autocomplete'ini implement et
    - Debounce ile API çağrısı
    - _Requirements: 3.2_
  - [x] 7.6 Property test: Study Field Visibility Based on Grade Level
    - **Property 4: Study Field Visibility Based on Grade Level**
    - **Validates: Requirements 2.2, 2.3**
  - [x] 7.7 Property test: City Change Resets Branch Selection
    - **Property 2: City Change Resets Branch Selection**
    - **Validates: Requirements 1.3**
  - [x] 7.8 Property test: Loading State During Async Operations
    - **Property 13: Loading State During Async Operations**
    - **Validates: Requirements 6.4**
  - [x] 7.9 Property test: Form State Preservation on Error
    - **Property 14: Form State Preservation on Error**
    - **Validates: Requirements 7.2**

- [x] 8. Form Gönderimi ve Hata Yönetimi
  - [x] 8.1 Form submit handler'ını implement et
    - Client-side validation → API call → Success/Error handling
    - _Requirements: 7.1, 7.2_
  - [x] 8.2 Başarı mesajı ve form reset'i implement et
    - _Requirements: 7.1_
  - [x] 8.3 Hata mesajlarını Türkçe olarak göster
    - _Requirements: 7.2_

- [x] 9. Gizlilik Politikası ve Son Dokunuşlar
  - [x] 9.1 Gizlilik politikası modal/sayfasını oluştur
    - _Requirements: 5.3_
  - [x] 9.2 Accessibility iyileştirmeleri (aria labels, focus states)
    - _Requirements: 6.3_
  - [x] 9.3 Form'un tüm cihazlarda responsive çalıştığını doğrula
    - _Requirements: 6.1, 6.2_

- [x] 10. Final Checkpoint - Tüm testlerin geçtiğinden emin ol
  - Ensure all tests pass, ask the user if questions arise.
