# Requirements Document

## Introduction

Bu doküman, eğitim kurumları için mobil öncelikli bir Aday Öğrenci Kayıt Formu sisteminin gereksinimlerini tanımlar. Form, velilerin telefonlarından kolayca doldurabilecekleri, sade ve anlaşılır bir arayüz sunacaktır. Sistem PHP backend ve TailwindCSS ile responsive tasarım kullanacaktır.

## Glossary

- **Kayıt Formu**: Aday öğrencilerin bilgilerini toplayan web formu
- **Şube**: Eğitim kurumunun belirli bir şehirdeki fiziksel lokasyonu
- **Sınıf Düzeyi**: Öğrencinin eğitim seviyesi (1-12. sınıf)
- **Alan Bilgisi**: Ortaöğretim öğrencilerinin (10-12. sınıf) seçtiği akademik alan (Sayısal, Sözel, Eşit Ağırlık, Dil)
- **Veli**: Öğrencinin yasal temsilcisi veya ebeveyni
- **Okul API**: Seçilen şehirdeki okulların listesini sağlayan harici servis

## Requirements

### Requirement 1

**User Story:** Bir veli olarak, şehir ve şube seçimi yapmak istiyorum, böylece çocuğumu doğru lokasyona kaydedebilirim.

#### Acceptance Criteria

1. WHEN kayıt formu yüklendiğinde THEN Kayıt Formu SHALL şehir seçim alanını ilk adım olarak görüntüleyecektir
2. WHEN veli bir şehir seçtiğinde THEN Kayıt Formu SHALL yalnızca o şehre ait şubeleri şube seçim alanında listeleyecektir
3. WHEN şehir seçimi değiştirildiğinde THEN Kayıt Formu SHALL şube seçimini sıfırlayacak ve yeni şehrin şubelerini yükleyecektir
4. WHEN şube seçilmeden form gönderilmeye çalışıldığında THEN Kayıt Formu SHALL kullanıcıya şube seçiminin zorunlu olduğunu belirten hata mesajı gösterecektir

### Requirement 2

**User Story:** Bir veli olarak, çocuğumun sınıf düzeyini ve varsa alan bilgisini seçmek istiyorum, böylece doğru eğitim programına yönlendirilebilsin.

#### Acceptance Criteria

1. WHEN şube seçildikten sonra THEN Kayıt Formu SHALL o şubeye ait sınıf düzeylerini seçim alanında görüntüleyecektir
2. WHEN veli 10, 11 veya 12. sınıf düzeyini seçtiğinde THEN Kayıt Formu SHALL alan bilgisi seçim alanını (Sayısal, Sözel, Eşit Ağırlık, Dil) görünür hale getirecektir
3. WHEN veli 1-9. sınıf düzeylerinden birini seçtiğinde THEN Kayıt Formu SHALL alan bilgisi seçim alanını gizleyecektir
4. WHEN ortaöğretim düzeyi seçilip alan bilgisi seçilmeden form gönderilmeye çalışıldığında THEN Kayıt Formu SHALL alan bilgisi seçiminin zorunlu olduğunu belirten hata mesajı gösterecektir

### Requirement 3

**User Story:** Bir veli olarak, çocuğumun kişisel bilgilerini girmek istiyorum, böylece kayıt işlemi tamamlanabilsin.

#### Acceptance Criteria

1. WHEN sınıf düzeyi seçildikten sonra THEN Kayıt Formu SHALL öğrenci adı ve soyadı giriş alanlarını görüntüleyecektir
2. WHEN veli okul arama alanına yazmaya başladığında THEN Kayıt Formu SHALL seçilen şehirdeki okulları API üzerinden arayacak ve eşleşen sonuçları listeleyecektir
3. WHEN öğrenci adı veya soyadı boş bırakılarak form gönderilmeye çalışıldığında THEN Kayıt Formu SHALL ilgili alanların zorunlu olduğunu belirten hata mesajı gösterecektir
4. WHEN okul seçilmeden form gönderilmeye çalışıldığında THEN Kayıt Formu SHALL okul seçiminin zorunlu olduğunu belirten hata mesajı gösterecektir

### Requirement 4

**User Story:** Bir veli olarak, kendi iletişim bilgilerimi girmek istiyorum, böylece kurum benimle iletişime geçebilsin.

#### Acceptance Criteria

1. WHEN öğrenci bilgileri girildikten sonra THEN Kayıt Formu SHALL veli adı, soyadı ve iki adet telefon numarası giriş alanını görüntüleyecektir
2. WHEN veli telefon numarası girerken THEN Kayıt Formu SHALL Türkiye telefon formatına (5XX XXX XX XX) uygun maske uygulayacaktır
3. WHEN veli adı, soyadı veya birinci telefon numarası boş bırakılarak form gönderilmeye çalışıldığında THEN Kayıt Formu SHALL ilgili alanların zorunlu olduğunu belirten hata mesajı gösterecektir
4. WHEN geçersiz telefon formatı girildiğinde THEN Kayıt Formu SHALL geçerli bir telefon numarası girilmesi gerektiğini belirten hata mesajı gösterecektir
5. WHILE ikinci telefon numarası opsiyonel iken WHEN ikinci telefon numarası girildiğinde THEN Kayıt Formu SHALL girilen numaranın format doğrulamasını yapacaktır

### Requirement 5

**User Story:** Bir veli olarak, gizlilik politikasını onaylamak istiyorum, böylece yasal gereklilikleri karşılayarak formu gönderebilsin.

#### Acceptance Criteria

1. WHEN form alanları doldurulduktan sonra THEN Kayıt Formu SHALL "Koşullar, gizlilik ve çerez politikasını okudum, kabul ediyorum" onay kutusunu görüntüleyecektir
2. WHEN onay kutusu işaretlenmeden form gönderilmeye çalışıldığında THEN Kayıt Formu SHALL politika onayının zorunlu olduğunu belirten hata mesajı gösterecektir
3. WHEN gizlilik politikası linkine tıklandığında THEN Kayıt Formu SHALL politika metnini yeni sekmede veya modal pencerede görüntüleyecektir

### Requirement 6

**User Story:** Bir veli olarak, formu mobil cihazımdan rahatça doldurmak istiyorum, böylece her yerden kayıt işlemini tamamlayabileyim.

#### Acceptance Criteria

1. WHILE form mobil cihazda görüntülenirken THEN Kayıt Formu SHALL tüm form elemanlarını tek sütun düzeninde, minimum 44px dokunma alanı ile görüntüleyecektir
2. WHILE form mobil cihazda görüntülenirken THEN Kayıt Formu SHALL okunabilir font boyutu (minimum 16px) kullanacaktır
3. WHEN form elemanları arasında geçiş yapılırken THEN Kayıt Formu SHALL mantıksal tab sırası ile klavye navigasyonunu destekleyecektir
4. WHILE form yüklenirken veya veri çekilirken THEN Kayıt Formu SHALL kullanıcıya yükleme durumunu gösteren görsel geri bildirim sağlayacaktır

### Requirement 7

**User Story:** Bir sistem yöneticisi olarak, form verilerinin güvenli şekilde kaydedilmesini istiyorum, böylece veri bütünlüğü sağlanabilsin.

#### Acceptance Criteria

1. WHEN form başarıyla gönderildiğinde THEN Kayıt Formu SHALL tüm verileri veritabanına kaydedecek ve kullanıcıya başarı mesajı gösterecektir
2. WHEN form gönderimi sırasında hata oluştuğunda THEN Kayıt Formu SHALL kullanıcıya anlaşılır hata mesajı gösterecek ve girilen verileri koruyacaktır
3. WHEN form verileri sunucuya gönderilirken THEN Kayıt Formu SHALL XSS ve SQL injection saldırılarına karşı tüm girdileri temizleyecektir
4. WHEN form verileri kaydedilirken THEN Kayıt Formu SHALL telefon numaralarını şifrelenmiş formatta saklayacaktır
